package gov.va.med.mhv.admin.web.formbean;

import gov.va.med.mhv.admin.dto.MVI1305SearchDTO;

import java.io.Serializable;
import java.util.Date;


public class MVI1305SearchInfoBean implements Serializable {

	private static final long serialVersionUID = 8171966386920864293L;
	
	private String firstName = null;
	private String middleName = null;
	private String lastName = null;
	private String prefix = null;
	private String suffix = null;
	private String gender = null;
	private String genderAbbreviated = null;
	private String ssn = null;
	private Date birthDate = null;
	private String homePhone = null;
	private String birthCity = null;
	private String birthState = null;
	private String birthCountry = null;
	private String mothersMaidenName = null;
	private String[] addressStreets = null;
	private String addressCity = null;
	private String addressState = null;
	private String addressZip = null;
	private String addressCountry = null;
	private String icn = null;

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getNamePrefix() {
		return prefix;
	}

	public void setNamePrefix(String prefix) {
		this.prefix = prefix;
	}

	public String getNameSuffix() {
		return suffix;
	}

	public void setNameSuffix(String suffix) {
		this.suffix = suffix;
	}

	/**
	 * @return The full name in the format 'lastName, firstName middleName', or <code>null</code>.
	 */
	public String getDisplayName() {
		StringBuilder fullName = new StringBuilder();
		
		addToCommaSeparatedString(fullName, prefix, false);
		addToCommaSeparatedString(fullName, lastName, false);
		addToCommaSeparatedString(fullName, firstName, true);
		addToCommaSeparatedString(fullName, middleName, false);
		addToCommaSeparatedString(fullName, suffix, false);
		
		return fullName.toString();
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		// Normalize the value
		if (gender != null) {
			if ("male".equalsIgnoreCase(gender) || "m".equalsIgnoreCase(gender)) {
				this.gender = "Male";
				this.genderAbbreviated = "M";
			} else if ("female".equalsIgnoreCase(gender) || "f".equalsIgnoreCase(gender)) {
				this.gender = "Female";
				this.genderAbbreviated = "F";
			} else {
				this.gender = null;
				this.genderAbbreviated = null;
			}
		}
	}

	public String getGenderAbbreviated() {
		return genderAbbreviated;
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}
	
	/**
	 * @return The SSN in the format '333-22-4444, or <code>null</code>.
	 */
	public String getSsnFormatted() {
		String formattedSsn = null;

		if (this.ssn != null) {
			if (this.ssn.indexOf("-") != -1 && this.ssn.length() == 11) {
				formattedSsn = this.ssn;
			} else if (this.ssn.indexOf("-") == -1 && this.ssn.length() == 9) {
				String[] ssnSegments = new String[3];
				ssnSegments[0] = this.ssn.substring(0, 3);
				ssnSegments[1] = this.ssn.substring(3, 5);
				ssnSegments[2] = this.ssn.substring(5);
				formattedSsn = ssnSegments[0] + "-" + ssnSegments[1] + "-" + ssnSegments[2];
			}
		}
		return formattedSsn;
	}

	public Date getBirthDate() {
		return birthDate;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}

	public String getHomePhone() {
		return homePhone;
	}

	public void setHomePhone(String homePhone) {
		this.homePhone = homePhone;
	}

	/**
	 * @return The home phone in the format (123) 456-7890 is possible.
	 */
	public String getHomePhoneFormatted() {
		if (homePhone != null) {
			String digits = homePhone.replaceAll("[\\D]", "");
			if (digits.length() == 10) {
				String areaCode = digits.substring(0, 3);
				String prefix = digits.substring(3, 6);
				String lastFour = digits.substring(6);
				return "(" + areaCode + ") " + prefix + "-" + lastFour;
			}
			else if (digits.length() == 7) {
				String prefix = digits.substring(4, 6);
				String lastFour = digits.substring(6);
				return  prefix + "-" + lastFour;
			}
		}
		return homePhone;
	}
	
	public String getBirthCity() {
		return birthCity;
	}

	public void setBirthCity(String birthCity) {
		this.birthCity = birthCity;
	}

	public String getBirthState() {
		return birthState;
	}

	public void setBirthState(String birthState) {
		this.birthState = birthState;
	}

	public String getBirthCountry() {
		return birthCountry;
	}

	public void setBirthCountry(String birthCountry) {
		this.birthCountry = birthCountry;
	}

	public String getMothersMaidenName() {
		return mothersMaidenName;
	}

	/**
	 * @return The birth place in the format 'city, state' or 'city' or 'state', or <code>null</code>.
	 */
	public String getBirthPlace() {
		StringBuilder birthPlace = new StringBuilder();
		
		addToCommaSeparatedString(birthPlace, birthCity, true);
		addToCommaSeparatedString(birthPlace, birthState, true);
		addToCommaSeparatedString(birthPlace, birthCountry, true);
		
		return birthPlace.toString();
	}
	
	public void setMothersMaidenName(String mothersMaidenName) {
		this.mothersMaidenName = mothersMaidenName;
	}

	public String[] getAddressStreets() {
		return addressStreets;
	}

	public void setAddressStreets(String[] addressStreets) {
		this.addressStreets = addressStreets;
	}
	
	public String getAddressCity() {
		return addressCity;
	}

	public void setAddressCity(String addressCity) {
		this.addressCity = addressCity;
	}

	public String getAddressState() {
		return addressState;
	}

	public void setAddressState(String addressState) {
		this.addressState = addressState;
	}

	public String getAddressZip() {
		return addressZip;
	}

	public void setAddressZip(String addressZip) {
		this.addressZip = addressZip;
	}
	
	public String getAddressCountry() {
		return addressCountry;
	}

	public void setAddressCountry(String addressCountry) {
		this.addressCountry = addressCountry;
	}
	
	public String getHomeAddress() {
		StringBuilder homeAddress = new StringBuilder();
		if (addressStreets != null) {
			for (String street : addressStreets) {
				addToCommaSeparatedString(homeAddress, street, true);
			}
		}
		addToCommaSeparatedString(homeAddress, addressCity, true);
		addToCommaSeparatedString(homeAddress, addressState, true);
		addToCommaSeparatedString(homeAddress, addressZip, true);
		addToCommaSeparatedString(homeAddress, addressCountry, true);
		return homeAddress.toString();
	}

	public String getIcn() {
		return icn;
	}

	public void setIcn(String icn) {
		this.icn = icn;
	}
	
	public static void addToCommaSeparatedString(StringBuilder target, String item, boolean showComma) {
		if (target != null) {
			if (item != null && target.length() == 0) {
				target.append(item.trim());
			} else if (item != null) {
				if (showComma) {
					target.append(", ");
				} else {
					target.append(" ");
				}
				target.append(item);
			}
		}
	}
	
	public static MVI1305SearchInfoBean convertDtoToBean(MVI1305SearchDTO dto) {
		MVI1305SearchInfoBean bean = null;
		
		if (dto != null) {
			bean = new MVI1305SearchInfoBean();
			bean.setFirstName(dto.getFirstName());
			bean.setMiddleName(dto.getMiddleName());
			bean.setLastName(dto.getLastName());
			bean.setGender(dto.getGender());
			bean.setSsn(dto.getSsn());
			bean.setBirthDate(dto.getBirthDate());
			bean.setHomePhone(dto.getHomePhone());
			bean.setBirthCity(dto.getBirthCity());
			bean.setBirthState(dto.getBirthState());
			bean.setBirthCountry(dto.getBirthCountry());
			bean.setAddressStreets(dto.getAddressStreets());
			bean.setAddressCity(dto.getAddressCity());
			bean.setAddressState(dto.getAddressState());
			bean.setAddressZip(dto.getAddressZip());
			bean.setIcn(dto.getIcn());
		}
		return bean;
	}

}
